#include <sys/io.h>
#include <stdio.h>
#include <stdlib.h>
//#include <curses.h>
#include <pthread.h>
#include <unistd.h>
#include <time.h>
#include "can.h"
#include "errcode.h"

/* For CAN bus operations */
int pkgNum = 10;
int baud = 125;
int pkgLength = 8;

canmsg_t samplePkg;
canmsg_t pkgHead;
/* End */

void func1(void)
{
  int i;
  samplePkg.length=8;

  for(i=0; i<8; i++)
    samplePkg.data[i] = i;

  sendCanMessages(&samplePkg, 1);


  return;
}

void func2(void)
{
  unsigned int result = -1;
  unsigned int id = 1;

  while(1)
  {
    canmsg_t pkg = { .flags = 0 };

    /* Ignition Status */
    result = getCanMessages( &pkg, 1);

    if( result != ERROR_API_SUCC ) {
      if( result == ERROR_API_CANGETMESSAGES )
        printf("Get CAN message error!!!\n");

      if( result == ERROR_API_CAN_OPEN_FAIL )
        printf("Open CAN device fail!!!\n");
    }

    printf("ID=%5d \n", id);
    printf("\t[%d]=%2x [%d]=%2x\n", 1, pkg.data[0], 2, pkg.data[1] );
    printf("\t[%d]=%2x [%d]=%2x\n", 3, pkg.data[2], 2, pkg.data[3] );
    printf("\t[%d]=%2x [%d]=%2x\n", 5, pkg.data[4], 2, pkg.data[5] );
    printf("\t[%d]=%2x [%d]=%2x\n\n", 7, pkg.data[6], 2, pkg.data[7] );

    id++;
  } 

  return;
}

void func3(void)
{
    int baud;
    int result;
    
    printf("Supported Baud rates: 10, 20, 50, 100, 125, 250, 500, 800, 1000\n");
    scanf("%d", &baud);
    result = -1;
    result = configCan(baud);
    if( result == ERRMSG( ERROR_API_CANCONFIG, ERROR_GEN_INPUT_DATA ) ) {
      printf("Wrong Baud rate!!!\n");
      sleep(1);

    }

    if( result == ERROR_GEN_DEVICE_FAIL ) {
      printf("Fail to set Baud rate!!!\n");
      sleep(1);
    }

    return;
}

void func4(void)
{
  int i;
  samplePkg.length=8;

  for(i=0; i<8; i++)
    samplePkg.data[i] = i;

  while(1)
    sendCanMessages(&samplePkg, 1);


  return;
}

struct FunctionTable {
  void (*func)(void);
  const char description[255];
};

struct FunctionTable funcTable[] = {
  {func1, "Send CAN packages"},
  {func2, "Get CAN packages"},
  {func3, "Set BAUD rate"},
  {func4, "CAN bus stress test, Send packages"},
};




int main(void)
{
  int i;
  int cmd=-1;

  printf("        Acrosser CAN Bus Utility\n");

  while(1)
  {
    printf("\n");
    printf("    ==========  Menu  ==========    \n");
    printf("      (0) Exit\n");

    for(i=0; i<(sizeof(funcTable)/sizeof(funcTable[0])); i++) {
      printf("      (%d) %s\n", i+1, funcTable[i].description);
    }
    printf("    ============================    \n");

CMD_RETRY:
    printf("    >> ");
    scanf("%d", &cmd);

    if( (cmd < 0) || (cmd > (sizeof(funcTable)/sizeof(funcTable[0]))) ) {
        printf("      Wrong Input! Please try again...\n");
        goto CMD_RETRY;
    }
      

    if( cmd==0 )
        break;

    (*(funcTable[cmd-1].func))();
   }

  exit(0);
}
